/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.quest.AreaSurvivalData;
import dev.toma.gunsrpg.common.quests.quest.AreaSurvivalQuest;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.IQuestFactory;
import dev.toma.gunsrpg.common.quests.quest.ItemHandoverData;
import dev.toma.gunsrpg.common.quests.quest.ItemHandoverQuest;
import dev.toma.gunsrpg.common.quests.quest.KillEntitiesQuest;
import dev.toma.gunsrpg.common.quests.quest.KillEntityData;
import dev.toma.gunsrpg.common.quests.quest.KillInAreaData;
import dev.toma.gunsrpg.common.quests.quest.KillInAreaQuest;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.SurvivalData;
import dev.toma.gunsrpg.common.quests.quest.SurvivalQuest;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class QuestTypes {
    private static final Map<ResourceLocation, QuestType<?, ?>> MAP = new HashMap();

    public static <D extends IQuestData, Q extends Quest<D>> QuestType<D, Q> register(ResourceLocation id, QuestType.IQuestDataResolver<D> resolver, IQuestFactory<D, Q> factory) {
        QuestType<D, Q> type = new QuestType<D, Q>(id, resolver, factory);
        MAP.put(id, type);
        return type;
    }

    public static <D extends IQuestData, Q extends Quest<D>> QuestType<D, Q> getTypeById(ResourceLocation id) {
        return MAP.get(id);
    }

    public static <D extends IQuestData, Q extends Quest<D>> Q getFromNbt(CompoundNBT nbt) {
        QuestDeserializationContext context = QuestDeserializationContext.fromNbt(nbt);
        QuestType type = context.getScheme().getQuestType();
        Object quest = type.fromContext(context);
        ((Quest)quest).readQuestData(context.getInternalData());
        return (Q)quest;
    }

    static {
        QuestTypes.register(GunsRPG.makeResource("kill_entities"), new KillEntityData.Serializer(), KillEntitiesQuest.FACTORY);
        QuestTypes.register(GunsRPG.makeResource("kill_in_area"), new KillInAreaData.Serializer(), KillInAreaQuest.FACTORY);
        QuestTypes.register(GunsRPG.makeResource("survival"), new SurvivalData.Serializer(), SurvivalQuest.FACTORY);
        QuestTypes.register(GunsRPG.makeResource("area_survival"), new AreaSurvivalData.Serializer(), AreaSurvivalQuest.FACTORY);
        QuestTypes.register(GunsRPG.makeResource("handover"), new ItemHandoverData.Serializer(), ItemHandoverQuest.FACTORY);
    }
}

